#include "DString.h"
#include <string.h>
#include <cstdlib>

namespace DWL {

    const size_t DStringMB::AgregarChar(const wchar_t NuevoChar) {
        wchar_t Tmp[2];
        Tmp[0] = NuevoChar;
        Tmp[1] = 0;
        return AgregarString(Tmp);
    }

    const size_t DStringMB::CopiarChar(const wchar_t NuevoChar) {
        wchar_t Tmp[2];
        Tmp[0] = NuevoChar;
        Tmp[1] = 0;
        return CopiarString(Tmp);
    }

    const size_t DStringMB::AgregarString(const char *NuevoString) {
        if (NuevoString == NULL) return _Text.size(); 
        try {
            _Text += NuevoString; 
        }
        catch (::std::bad_alloc) {
            throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_ReservandoMemoria));
            return _Text.size();
        }
        return _Text.size(); 
    }

    const size_t DStringMB::CopiarString(const char *NuevoString) {
        if (NuevoString == NULL) return _Text.size(); 
        try {
            _Text = NuevoString; 
        }
        catch (::std::bad_alloc) {
            throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_ReservandoMemoria));
            return _Text.size();
        }
        return _Text.size(); 
    }

    const size_t DStringMB::_AgregarStringWide(const wchar_t *NuevoString, const size_t NewSize) {
        char *Dest = 0;
        size_t TempSize = NewSize;
        if (TempSize == DWL_STR_MAX) TempSize = wcslen(NuevoString);
        try {
            Dest = new char[TempSize + 1];
        }
        catch (::std::bad_alloc) {
            throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_ReservandoMemoria));
            return _Text.size();
        }
        #if _MSC_VER > 1400
            wcstombs_s(0, Dest, TempSize + 1, NuevoString, TempSize);
        #else 
            wcstombs(Dest, NuevoString, TempSize);
        #endif
        Dest[TempSize] = 0;
        try {
            _Text += Dest;
        }
        catch (::std::bad_alloc) {
            throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_ReservandoMemoria));
            return _Text.size();
        }

        delete [] Dest;
        return _Text.size();
    }

    DStringMB DStringMB::SubStr(const size_t nInicio, const size_t TotalCaracteres) {
        DStringWC Ret;
        if (nInicio > _Text.size()) {
            throw(DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_IndiceInvalido));
            return Ret;
        }
        size_t nTotalCaracteres = TotalCaracteres;
        if (nTotalCaracteres == 0) nTotalCaracteres = _Text.size() - nInicio;
        try {
            if (nInicio + nTotalCaracteres < _Text.size())  Ret = _Text.substr(nInicio, nTotalCaracteres).c_str();
            else                                            Ret = _Text.substr(nInicio, _Text.size() - nInicio).c_str();
        }
        catch (::std::bad_alloc) {
            throw(DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_ReservandoMemoria));
            return Ret;
        }

        return Ret;
    }

    const size_t DStringMB::_AgregarStringWide(const DStringWC &NuevoString) {
        return _AgregarStringWide(NuevoString(), NuevoString.Tam());
    }

    const int DStringMB::_CompararBinario(const char *String1, const char *String2) const {
        for (; *String1 && *String2 && *String1 == *String2; ++String1, ++String2);
        return *String1 - *String2;
    }

    const int DStringMB::_CompararInsensitivo(const char *String1, const char *String2) const {
        for (; *String1 && *String2 && toupper(*String1) == toupper(*String2); ++String1, ++String2);
        return *String1 - *String2;
    }



    DStringWC DStringMB::WideChar(void) {
        return DStringWC(_Text);
    }

/*    DStringWC DStringMB::ToMultiByte(void) {
        return DStringWC(_Text);
    }*/



    const size_t DStringWC::AgregarChar(const char NuevoChar) {
        char Tmp[2];
        Tmp[0] = NuevoChar;
        Tmp[1] = 0;
        return AgregarString(Tmp);
    }

    const size_t DStringWC::CopiarChar(const char NuevoChar) {
        char Tmp[2];
        Tmp[0] = NuevoChar;
        Tmp[1] = 0;
        return CopiarString(Tmp);
    }

    const size_t DStringWC::AgregarString(const wchar_t *NuevoString) {
        if (NuevoString == NULL) return _Text.size(); 
        try {
            _Text += NuevoString; 
        }
        catch (::std::bad_alloc) {
            throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_ReservandoMemoria));
            return _Text.size();
        }
        return _Text.size(); 
    }

    const size_t DStringWC::CopiarString(const wchar_t *NuevoString) {
        if (NuevoString == NULL) return _Text.size(); 
        try {
            _Text = NuevoString; 
        }
        catch (::std::bad_alloc) {
            throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_ReservandoMemoria));
            return _Text.size();
        }
        return _Text.size(); 
    }
    
    const size_t DStringWC::_AgregarStringMultiByte(const char *NuevoString, const size_t NewSize) {
        wchar_t *Dest = 0;
        size_t TempSize = NewSize;
        if (TempSize == DWL_STR_MAX) TempSize = strlen(NuevoString);
        try {
            Dest = new wchar_t[TempSize + 1];
        }
        catch (::std::bad_alloc) {
            throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_ReservandoMemoria));
            return _Text.size();
        }
        #if _MSC_VER > 1400
            mbstowcs_s(0, Dest, TempSize + 1, NuevoString, TempSize);
        #else 
            mbstowcs(Dest, NuevoString, TempSize);
        #endif
        Dest[TempSize] = 0;
        try {
            _Text += Dest;
        }
        catch (::std::bad_alloc) {
            throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_ReservandoMemoria));
            return _Text.size();
        }
        delete [] Dest;
        return _Text.size();
    }

    DStringWC DStringWC::SubStr(const size_t nInicio, const size_t TotalCaracteres) {
        DStringWC Ret;
        if (nInicio > _Text.size()) {
            throw(DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_IndiceInvalido));
            return Ret;
        }
        size_t nTotalCaracteres = TotalCaracteres;
        if (nTotalCaracteres == 0) nTotalCaracteres = _Text.size() - nInicio;
        try {
            if (nInicio + nTotalCaracteres < _Text.size())  Ret = _Text.substr(nInicio, nTotalCaracteres).c_str();
            else                                            Ret = _Text.substr(nInicio, _Text.size() - nInicio).c_str();
        }
        catch (::std::bad_alloc) {
            throw(DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_ReservandoMemoria));
            return Ret;
        }
        return Ret;
    }

    const int DStringWC::_CompararBinario(const wchar_t *String1, const wchar_t *String2) const {
        for (; *String1 && *String2 && *String1 == *String2; ++String1, ++String2);
        return *String1 - *String2;
    }

    const int DStringWC::_CompararInsensitivo(const wchar_t *String1, const wchar_t *String2) const {
        for (; *String1 && *String2 && toupper(*String1) == toupper(*String2); ++String1, ++String2);
        return *String1 - *String2;
    }
}